'use strict';

angular.module('static_models', [])
    .factory('NavigationItems', function(){
        var items = [
            {
                name: 'Grupy'
                ,link: 'groups'
                ,type: 'groups'
                ,title: 'Zarządzanie grupami'
                ,iconCls: 'fa fa-users'
            }
            ,{
                name: 'Ustawienia'
                ,link: 'settings'
                ,type: 'settings'
                ,title: 'Ustawienia'
                ,iconCls: 'fa fa-users'
            }
            ,{
                name: 'Tury'
                ,link: 'rounds'
                ,type: 'rounds'
                ,title: 'Zarządzanie turami'
                ,iconCls: 'fa fa-users'
            }
            ,{
                name: 'Wyniki'
                ,link: 'results/ranking'
                ,type: 'results'
                ,title: 'Wyniki'
                ,iconCls: 'fa fa-users'
            }
            ,{
                name: 'Notowania'
                ,link: 'quotes'
                ,type: 'quotes'
                ,title: 'Notowania'
                ,iconCls: 'fa fa-users'
            }
            ,{
                name: 'Wskaźniki'
                ,link: 'indicators'
                ,type: 'indicators'
                ,title: 'Wskaźniki'
                ,iconCls: 'fa fa-users'
            }
        ];
        return {
            getItems: function(){
                return items;
            }
            ,getItemByLink: function(link){
                var item = {};
                angular.forEach(items, function(nav){
                    if(nav.type == link)
                    {
                        item = nav;
                    }
                })
                return item;
            }
        }
    })